/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BloodfeatherPhoenixEffect
extends OneShotEffect {
    BloodfeatherPhoenixEffect() {
        super(Outcome.Benefit);
        this.staticText = "return {this} from your graveyard to the battlefield. It gains haste until end of turn";
    }

    private BloodfeatherPhoenixEffect(BloodfeatherPhoenixEffect effect) {
        super((OneShotEffect)effect);
    }

    public BloodfeatherPhoenixEffect copy() {
        return new BloodfeatherPhoenixEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Card card = source.getSourceCardIfItStillExists(game);
        if (controller == null || card == null) {
            return false;
        }
        controller.moveCards(card, Zone.BATTLEFIELD, source, game);
        if (game.getPermanent(source.getSourceId()) != null) {
            game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance()).setTargetPointer((TargetPointer)new FixedTarget(source.getSourceId(), game)), source);
        }
        return true;
    }
}

