/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.costs.Cost;
import mage.abilities.costs.mana.ManaCostsImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.DoIfCostPaid;
import mage.cards.b.BloodfeatherPhoenixEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;
import mage.game.stack.Spell;

class BloodfeatherPhoenixTriggeredAbility
extends TriggeredAbilityImpl {
    BloodfeatherPhoenixTriggeredAbility() {
        super(Zone.GRAVEYARD, (Effect)new DoIfCostPaid((Effect)new BloodfeatherPhoenixEffect(), (Cost)new ManaCostsImpl("{R}")));
        this.setTriggerPhrase("Whenever an instant or sorcery spell you control deals damage to an opponent or battle, ");
    }

    private BloodfeatherPhoenixTriggeredAbility(BloodfeatherPhoenixTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public BloodfeatherPhoenixTriggeredAbility copy() {
        return new BloodfeatherPhoenixTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.DAMAGED_PERMANENT || event.getType() == GameEvent.EventType.DAMAGED_PLAYER;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Spell spell = game.getSpellOrLKIStack(event.getSourceId());
        if (spell == null || !this.isControlledBy(spell.getControllerId()) || !spell.isInstantOrSorcery(game)) {
            return false;
        }
        if (game.getOpponents(event.getTargetId()).contains(this.getControllerId())) {
            return true;
        }
        Permanent permanent = game.getPermanent(event.getTargetId());
        return permanent != null && permanent.isBattle(game);
    }
}

