/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashMap;
import java.util.Map;
import mage.abilities.Ability;
import mage.abilities.StateTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.cards.b.BloodletterEffect;
import mage.constants.Zone;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterNonlandPermanent;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class BloodletterStateTriggeredAbility
extends StateTriggeredAbility {
    public BloodletterStateTriggeredAbility() {
        super(Zone.BATTLEFIELD, (Effect)new BloodletterEffect());
        this.setTriggerPhrase("When the names of three or more nonland permanents begin with the same letter, ");
    }

    private BloodletterStateTriggeredAbility(BloodletterStateTriggeredAbility ability) {
        super((StateTriggeredAbility)ability);
    }

    public BloodletterStateTriggeredAbility copy() {
        return new BloodletterStateTriggeredAbility(this);
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        HashMap<Character, Integer> initialCount = new HashMap<Character, Integer>();
        for (Permanent permanent : game.getBattlefield().getActivePermanents((FilterPermanent)new FilterNonlandPermanent(), this.getControllerId(), (Ability)this, game)) {
            Character initial = Character.valueOf(permanent.getName().charAt(0));
            initialCount.putIfAbsent(initial, 0);
            initialCount.put(initial, (Integer)initialCount.get(initial) + 1);
        }
        for (Map.Entry entry : initialCount.entrySet()) {
            if ((Integer)entry.getValue() < 3) continue;
            return true;
        }
        return false;
    }
}

