/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class BloodsoakedInsightTargetEffect
extends OneShotEffect {
    BloodsoakedInsightTargetEffect() {
        super(Outcome.Detriment);
        this.staticText = "Target opponent exiles the top three cards of their library. Until the end of your next turn, you may play those cards. If you cast a spell this way, mana of any type can be spent to cast it.";
    }

    private BloodsoakedInsightTargetEffect(BloodsoakedInsightTargetEffect effect) {
        super((OneShotEffect)effect);
    }

    public BloodsoakedInsightTargetEffect copy() {
        return new BloodsoakedInsightTargetEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (controller == null || opponent == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(opponent.getLibrary().getTopCards(game, 3));
        if (cards.isEmpty()) {
            return false;
        }
        UUID exileId = CardUtil.getExileZoneId((Game)game, (Ability)source);
        MageObject sourceObject = source.getSourceObject(game);
        String exileName = sourceObject == null ? null : sourceObject.getIdName();
        controller.moveCardsToExile(cards.getCards(game), source, game, true, exileId, exileName);
        cards.retainZone(Zone.EXILED, game);
        for (Card card : cards.getCards(game)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.UntilEndOfYourNextTurn, (boolean)true);
        }
        return true;
    }
}

