/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.RestrictionEffect;
import mage.cards.b.BloodthirsterWatcher;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BloodthirsterEffect
extends RestrictionEffect {
    BloodthirsterEffect() {
        super(Duration.WhileOnBattlefield);
        this.staticText = "{this} can't attack a player it has already attacked this turn";
    }

    private BloodthirsterEffect(BloodthirsterEffect effect) {
        super((RestrictionEffect)effect);
    }

    public BloodthirsterEffect copy() {
        return new BloodthirsterEffect(this);
    }

    public boolean canAttack(Permanent attacker, UUID defenderId, Ability source, Game game, boolean canUseChooseDialogs) {
        BloodthirsterWatcher watcher = (BloodthirsterWatcher)game.getState().getWatcher(BloodthirsterWatcher.class);
        return watcher != null && watcher.checkAttacker(attacker, defenderId);
    }

    public boolean applies(Permanent permanent, Ability source, Game game) {
        return permanent.getId().equals(source.getSourceId());
    }
}

