/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInYourGraveyard;

class BlossomingTortoiseEffect
extends OneShotEffect {
    BlossomingTortoiseEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then return a land card from your graveyard to the battlefield tapped";
    }

    private BlossomingTortoiseEffect(BlossomingTortoiseEffect effect) {
        super((OneShotEffect)effect);
    }

    public BlossomingTortoiseEffect copy() {
        return new BlossomingTortoiseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getGraveyard().count((FilterCard)StaticFilters.FILTER_CARD_LAND, game) < 1) {
            return false;
        }
        TargetCardInYourGraveyard target = new TargetCardInYourGraveyard((FilterCard)StaticFilters.FILTER_CARD_LAND);
        target.withNotTarget(true);
        player.choose(this.outcome, (Target)target, source, game);
        Card card = game.getCard(target.getFirstTarget());
        return card != null && player.moveCards(card, Zone.BATTLEFIELD, source, game, true, false, false, null);
    }
}

