/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.MageObjectReference;
import mage.abilities.Ability;
import mage.abilities.common.SimpleStaticAbility;
import mage.abilities.effects.ContinuousEffectImpl;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.continuous.BoostEquippedEffect;
import mage.abilities.keyword.EquipAbility;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Layer;
import mage.constants.Outcome;
import mage.constants.SubLayer;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterArtifactPermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BludgeonBrawlEffect
extends ContinuousEffectImpl {
    private static final FilterPermanent filter = new FilterArtifactPermanent();

    public BludgeonBrawlEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "each noncreature, non-Equipment artifact is an Equipment with equip {X} and \"Equipped creature gets +X/+0,\" where X is that artifact's mana value.";
    }

    private BludgeonBrawlEffect(BludgeonBrawlEffect effect) {
        super((ContinuousEffectImpl)effect);
    }

    public boolean apply(Layer layer, SubLayer sublayer, Ability source, Game game) {
        if (layer == Layer.TypeChangingEffects_4) {
            this.affectedObjectList.clear();
            for (Permanent permanent : game.getBattlefield().getActivePermanents(filter, source.getControllerId(), source, game)) {
                this.affectedObjectList.add(new MageObjectReference((MageObject)permanent, game));
            }
        }
        for (MageObjectReference mor : this.affectedObjectList) {
            Permanent permanent = mor.getPermanent(game);
            switch (layer) {
                case TypeChangingEffects_4: {
                    permanent.addSubType(game, new SubType[]{SubType.EQUIPMENT});
                    break;
                }
                case AbilityAddingRemovingEffects_6: {
                    int mv = permanent.getManaValue();
                    permanent.addAbility((Ability)new SimpleStaticAbility((Effect)new BoostEquippedEffect(mv, 0)), source.getSourceId(), game);
                    permanent.addAbility((Ability)new EquipAbility(mv, false), source.getSourceId(), game);
                }
            }
        }
        return true;
    }

    public boolean apply(Game game, Ability source) {
        return false;
    }

    public BludgeonBrawlEffect copy() {
        return new BludgeonBrawlEffect(this);
    }

    public boolean hasLayer(Layer layer) {
        switch (layer) {
            case TypeChangingEffects_4: 
            case AbilityAddingRemovingEffects_6: {
                return true;
            }
        }
        return false;
    }

    static {
        filter.add(Predicates.not((Predicate)CardType.CREATURE.getPredicate()));
        filter.add(Predicates.not((Predicate)SubType.EQUIPMENT.getPredicate()));
    }
}

