/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Set;
import mage.abilities.Ability;
import mage.abilities.effects.ReplacementEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.game.Game;
import mage.game.events.EntersTheBattlefieldEvent;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class BlueLoyalRaptorEffect
extends ReplacementEffectImpl {
    private static final FilterPermanent filter = new FilterPermanent(SubType.DINOSAUR, "Dinosaur");

    BlueLoyalRaptorEffect() {
        super(Duration.WhileOnBattlefield, Outcome.BoostCreature);
        this.staticText = "For each kind of counter on {this}, each other " + filter.getMessage() + " you control enters the battlefield with a counter of that kind on it.";
    }

    private BlueLoyalRaptorEffect(BlueLoyalRaptorEffect effect) {
        super((ReplacementEffectImpl)effect);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.ENTERS_THE_BATTLEFIELD;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent creature = ((EntersTheBattlefieldEvent)event).getTarget();
        return creature != null && creature.isControlledBy(source.getControllerId()) && filter.match((Object)creature, game) && !event.getTargetId().equals(source.getSourceId());
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        Permanent sourcePermanent = source.getSourcePermanentIfItStillExists(game);
        Permanent targetPermanent = ((EntersTheBattlefieldEvent)event).getTarget();
        if (sourcePermanent == null || targetPermanent == null) {
            return false;
        }
        Set counterTypes = sourcePermanent.getCounters(game).keySet();
        for (String counterType : counterTypes) {
            targetPermanent.addCounters(CounterType.findByName((String)counterType).createInstance(), source.getControllerId(), source, game);
        }
        return false;
    }

    public BlueLoyalRaptorEffect copy() {
        return new BlueLoyalRaptorEffect(this);
    }
}

