/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.common.FilterCreatureCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCardInGraveyard;

class BodyDoubleCopyEffect
extends OneShotEffect {
    BodyDoubleCopyEffect() {
        super(Outcome.Copy);
        this.staticText = "as a copy of any creature card in a graveyard";
    }

    private BodyDoubleCopyEffect(BodyDoubleCopyEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            TargetCardInGraveyard target = new TargetCardInGraveyard((FilterCard)new FilterCreatureCard("creature card in a graveyard"));
            target.withNotTarget(true);
            if (target.canChoose(source.getControllerId(), source, game)) {
                player.choose(this.outcome, (Target)target, source, game);
                Card copyFromCard = game.getCard(target.getFirstTarget());
                if (copyFromCard != null) {
                    CopyEffect copyEffect = new CopyEffect(Duration.Custom, (MageObject)copyFromCard, source.getSourceId());
                    game.addEffect((ContinuousEffect)copyEffect, source);
                }
            }
            return true;
        }
        return false;
    }

    public BodyDoubleCopyEffect copy() {
        return new BodyDoubleCopyEffect(this);
    }
}

