/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.condition.common.KickedCondition;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.BoostControlledEffect;
import mage.abilities.effects.common.continuous.GainAbilityControlledEffect;
import mage.abilities.keyword.FirstStrikeAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;

class BoldDefenseEffect
extends OneShotEffect {
    BoldDefenseEffect() {
        super(Outcome.Benefit);
        this.staticText = "Creatures you control get +1/+1 until end of turn. If this spell was kicked, instead creatures you control get +2/+2 and gain first strike until end of turn.";
    }

    private BoldDefenseEffect(BoldDefenseEffect effect) {
        super((OneShotEffect)effect);
    }

    public BoldDefenseEffect copy() {
        return new BoldDefenseEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        if (KickedCondition.ONCE.apply(game, source)) {
            game.addEffect((ContinuousEffect)new BoostControlledEffect(2, 2, Duration.EndOfTurn), source);
            game.addEffect((ContinuousEffect)new GainAbilityControlledEffect((Ability)FirstStrikeAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE), source);
        } else {
            game.addEffect((ContinuousEffect)new BoostControlledEffect(1, 1, Duration.EndOfTurn), source);
        }
        return true;
    }
}

