/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.SpellAbility;
import mage.abilities.condition.common.MorbidCondition;
import mage.abilities.effects.common.cost.CostModificationEffectImpl;
import mage.constants.CostModificationType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.util.CardUtil;

class BonePickerAdjustingCostsEffect
extends CostModificationEffectImpl {
    BonePickerAdjustingCostsEffect() {
        super(Duration.EndOfGame, Outcome.Benefit, CostModificationType.REDUCE_COST);
        this.staticText = "this spell costs {3} less to cast if a creature died this turn";
    }

    private BonePickerAdjustingCostsEffect(BonePickerAdjustingCostsEffect effect) {
        super((CostModificationEffectImpl)effect);
    }

    public boolean apply(Game game, Ability source, Ability abilityToModify) {
        CardUtil.reduceCost((Ability)abilityToModify, (int)3);
        return true;
    }

    public boolean applies(Ability abilityToModify, Ability source, Game game) {
        return abilityToModify.getSourceId().equals(source.getSourceId()) && abilityToModify instanceof SpellAbility && MorbidCondition.instance.apply(game, abilityToModify);
    }

    public BonePickerAdjustingCostsEffect copy() {
        return new BonePickerAdjustingCostsEffect(this);
    }
}

