/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.cards.Card;
import mage.constants.SubType;
import mage.constants.WatcherScope;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.ZoneChangeEvent;
import mage.game.permanent.Permanent;
import mage.util.CardUtil;
import mage.watchers.Watcher;

class BonecacheOverseerWatcher
extends Watcher {
    private final Map<UUID, Integer> graveyardMap = new HashMap<UUID, Integer>();
    private final Set<UUID> foodSet = new HashSet<UUID>();

    BonecacheOverseerWatcher() {
        super(WatcherScope.GAME);
    }

    public void watch(GameEvent event, Game game) {
        switch (event.getType()) {
            case ZONE_CHANGE: {
                ZoneChangeEvent zEvent = (ZoneChangeEvent)event;
                if (!Zone.GRAVEYARD.match(zEvent.getFromZone())) {
                    return;
                }
                Card card = game.getCard(zEvent.getTargetId());
                if (card != null) {
                    this.graveyardMap.compute(card.getOwnerId(), CardUtil::setOrIncrementValue);
                }
                return;
            }
            case SACRIFICED_PERMANENT: {
                Permanent permanent = game.getPermanentOrLKIBattlefield(event.getTargetId());
                if (permanent == null || !permanent.hasSubtype(SubType.FOOD, game)) break;
                this.foodSet.add(permanent.getControllerId());
            }
        }
    }

    public void reset() {
        super.reset();
        this.graveyardMap.clear();
        this.foodSet.clear();
    }

    static boolean checkPlayer(Game game, Ability source) {
        return ((BonecacheOverseerWatcher)game.getState().getWatcher(BonecacheOverseerWatcher.class)).check(source.getControllerId());
    }

    private boolean check(UUID playerId) {
        return this.foodSet.contains(playerId) || this.graveyardMap.getOrDefault(playerId, 0) >= 3;
    }
}

