/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetOpponent;

class BoneyardParleyEffect
extends OneShotEffect {
    BoneyardParleyEffect() {
        super(Outcome.Benefit);
        this.staticText = "Exile up to five target creature cards from graveyards. An opponent separates those cards into two piles. Put all cards from the pile of your choice onto the battlefield under your control and the rest into their owners' graveyards";
    }

    private BoneyardParleyEffect(BoneyardParleyEffect effect) {
        super((OneShotEffect)effect);
    }

    public BoneyardParleyEffect copy() {
        return new BoneyardParleyEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player != null) {
            TargetOpponent targetOpponent;
            CardsImpl cards = new CardsImpl();
            for (Target target : source.getTargets()) {
                cards.addAll((Collection)target.getTargets());
            }
            if (!cards.isEmpty() && player.moveCards((Cards)cards, Zone.EXILED, source, game) && player.choose(Outcome.Neutral, (Target)(targetOpponent = new TargetOpponent(true)), source, game)) {
                Player opponent = game.getPlayer(targetOpponent.getFirstTarget());
                if (opponent != null) {
                    TargetCard targetCards = new TargetCard(0, cards.size(), Zone.EXILED, new FilterCard("cards to put in the first pile"));
                    ArrayList<Card> pile1 = new ArrayList<Card>();
                    if (opponent.choose(Outcome.Neutral, (Cards)cards, targetCards, source, game)) {
                        List targets = targetCards.getTargets();
                        for (UUID targetId : targets) {
                            Card card = cards.get(targetId, game);
                            if (card == null) continue;
                            pile1.add(card);
                            cards.remove(card);
                        }
                    }
                    ArrayList pile2 = new ArrayList();
                    pile2.addAll(cards.getCards(game));
                    boolean choice = player.choosePile(this.outcome, "Choose a pile to put onto the battlefield.", pile1, pile2, game);
                    Zone pile1Zone = Zone.GRAVEYARD;
                    Zone pile2Zone = Zone.BATTLEFIELD;
                    if (choice) {
                        pile1Zone = Zone.BATTLEFIELD;
                        pile2Zone = Zone.GRAVEYARD;
                    }
                    HashSet<Card> pile1Set = new HashSet<Card>();
                    HashSet pile2Set = new HashSet();
                    pile1Set.addAll(pile1);
                    pile2Set.addAll(pile2);
                    player.moveCards(pile1Set, pile1Zone, source, game, false, false, false, null);
                    player.moveCards(pile2Set, pile2Zone, source, game, false, false, false, null);
                }
                return true;
            }
        }
        return false;
    }
}

