/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class BookBurningMillEffect
extends OneShotEffect {
    BookBurningMillEffect() {
        super(Outcome.Detriment);
        this.staticText = "Any player may have {this} deal 6 damage to them. If no one does, target player mills six cards";
    }

    private BookBurningMillEffect(BookBurningMillEffect effect) {
        super((OneShotEffect)effect);
    }

    public BookBurningMillEffect copy() {
        return new BookBurningMillEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        MageObject sourceObject = source.getSourceObject(game);
        if (sourceObject != null) {
            Player targetPlayer;
            boolean millCards = true;
            for (UUID playerId : game.getState().getPlayersInRange(source.getControllerId(), game)) {
                Player player = game.getPlayer(playerId);
                if (player == null || !player.chooseUse(Outcome.Detriment, "Have " + sourceObject.getLogName() + " deal 6 damage to you?", source, game)) continue;
                millCards = false;
                player.damage(6, source.getSourceId(), source, game);
                game.informPlayers(player.getLogName() + " has " + sourceObject.getLogName() + " deal 6 damage to them");
            }
            if (millCards && (targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source))) != null) {
                targetPlayer.moveCards(targetPlayer.getLibrary().getTopCards(game, 6), Zone.GRAVEYARD, source, game);
            }
            return true;
        }
        return false;
    }
}

