/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;
import mage.target.common.TargetDiscard;

class BorborygmosAndFblthpDiscardEffect
extends OneShotEffect {
    BorborygmosAndFblthpDiscardEffect() {
        super(Outcome.Benefit);
        this.staticText = "draw a card, then you may discard any number of land cards. When you discard one or more cards this way, {this} deals twice that much damage to target creature";
    }

    private BorborygmosAndFblthpDiscardEffect(BorborygmosAndFblthpDiscardEffect effect) {
        super((OneShotEffect)effect);
    }

    public BorborygmosAndFblthpDiscardEffect copy() {
        return new BorborygmosAndFblthpDiscardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        player.drawCards(1, source, game);
        TargetDiscard target = new TargetDiscard(0, Integer.MAX_VALUE, (FilterCard)StaticFilters.FILTER_CARD_LANDS, player.getId());
        player.choose(Outcome.Discard, (Target)target, source, game);
        Cards cards = player.discard((Cards)new CardsImpl((Collection)target.getTargets()), false, source, game);
        if (cards.isEmpty()) {
            return true;
        }
        int damage = 2 * cards.size();
        ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(damage), false, "{this} deals twice that much damage to target creature");
        ability.addTarget((Target)new TargetCreaturePermanent());
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

