/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.condition.Condition;
import mage.abilities.condition.common.ManaWasSpentCondition;
import mage.abilities.decorator.ConditionalOneShotEffect;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.PreventDamageByTargetEffect;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.constants.CardType;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterAttackingOrBlockingCreature;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;

public final class BorosFuryShield
extends CardImpl {
    private static final FilterAttackingOrBlockingCreature filter = new FilterAttackingOrBlockingCreature();

    public BorosFuryShield(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.INSTANT}, "{2}{W}");
        this.getSpellAbility().addEffect((Effect)new PreventDamageByTargetEffect(Duration.EndOfTurn, true));
        this.getSpellAbility().addTarget((Target)new TargetPermanent((FilterPermanent)filter));
        this.getSpellAbility().addEffect((Effect)new ConditionalOneShotEffect((OneShotEffect)new BorosFuryShieldDamageEffect(), (Condition)ManaWasSpentCondition.RED, "If {R} was spent to cast this spell, {this} deals damage to that creature's controller equal to the creature's power"));
    }

    private BorosFuryShield(BorosFuryShield card) {
        super((CardImpl)card);
    }

    public BorosFuryShield copy() {
        return new BorosFuryShield(this);
    }

    static class BorosFuryShieldDamageEffect
    extends OneShotEffect {
        BorosFuryShieldDamageEffect() {
            super(Outcome.Damage);
            this.staticText = "{this} deals damage to that creature's controller equal to the creature's power";
        }

        private BorosFuryShieldDamageEffect(BorosFuryShieldDamageEffect effect) {
            super((OneShotEffect)effect);
        }

        public boolean apply(Game game, Ability source) {
            Player player;
            Permanent target = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
            if (target != null && (player = game.getPlayer(target.getControllerId())) != null) {
                int power = target.getPower().getValue();
                player.damage(power, source.getId(), source, game);
            }
            return false;
        }

        public BorosFuryShieldDamageEffect copy() {
            return new BorosFuryShieldDamageEffect(this);
        }
    }
}

