/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class BoundInGoldEffect
extends ContinuousRuleModifyingEffectImpl {
    BoundInGoldEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Detriment);
        this.staticText = ", or crew Vehicles, and its activated abilities can't be activated unless they're mana abilities";
    }

    private BoundInGoldEffect(BoundInGoldEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public BoundInGoldEffect copy() {
        return new BoundInGoldEffect(this);
    }

    public boolean checksEventType(GameEvent event, Game game) {
        switch (event.getType()) {
            case CREW_VEHICLE: 
            case ACTIVATE_ABILITY: {
                return true;
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Permanent enchantment = game.getPermanent(source.getSourceId());
        if (enchantment != null) {
            switch (event.getType()) {
                case CREW_VEHICLE: {
                    return enchantment.isAttachedTo(event.getTargetId());
                }
                case ACTIVATE_ABILITY: {
                    if (!enchantment.isAttachedTo(event.getSourceId())) break;
                    Optional ability = game.getAbility(event.getTargetId(), event.getSourceId());
                    return ability.isPresent() && ((Ability)ability.get()).isNonManaActivatedAbility();
                }
            }
        }
        return false;
    }
}

