/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.common.ActivateAsSorceryActivatedAbility;
import mage.abilities.common.DiesCreatureTriggeredAbility;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.TapSourceCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.Effect;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.abilities.mana.AnyColorManaAbility;
import mage.cards.CardImpl;
import mage.cards.CardSetInfo;
import mage.cards.b.BountyBoardEffect;
import mage.constants.CardType;
import mage.counters.CounterType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.target.Target;
import mage.target.common.TargetCreaturePermanent;

public final class BountyBoard
extends CardImpl {
    private static final FilterPermanent filter = new FilterCreaturePermanent("a creature with a bounty counter on it");

    public BountyBoard(UUID ownerId, CardSetInfo setInfo) {
        super(ownerId, setInfo, new CardType[]{CardType.ARTIFACT}, "{3}");
        this.addAbility((Ability)new AnyColorManaAbility());
        ActivateAsSorceryActivatedAbility ability = new ActivateAsSorceryActivatedAbility((Effect)new AddCountersTargetEffect(CounterType.BOUNTY.createInstance()), (Cost)new GenericManaCost(1));
        ability.addCost((Cost)new TapSourceCost());
        ability.addTarget((Target)new TargetCreaturePermanent());
        this.addAbility((Ability)ability);
        this.addAbility((Ability)new DiesCreatureTriggeredAbility((Effect)new BountyBoardEffect(), false, filter));
    }

    private BountyBoard(BountyBoard card) {
        super((CardImpl)card);
    }

    public BountyBoard copy() {
        return new BountyBoard(this);
    }

    static {
        filter.add((Predicate)CounterType.BOUNTY.getPredicate());
    }
}

