/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Stream;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Controllable;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BountyBoardEffect
extends OneShotEffect {
    BountyBoardEffect() {
        super(Outcome.Benefit);
        this.staticText = "each of its controller's opponents draws a card and gains 2 life";
    }

    private BountyBoardEffect(BountyBoardEffect effect) {
        super((OneShotEffect)effect);
    }

    public BountyBoardEffect copy() {
        return new BountyBoardEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Optional.ofNullable(this.getValue("creatureDied")).map(Permanent.class::cast).map(Controllable::getControllerId).map(arg_0 -> ((Game)game).getOpponents(arg_0)).map(Collection::stream).orElseGet(Stream::empty).map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).forEach(player -> {
            player.drawCards(1, source, game);
            player.gainLife(2, game, source);
        });
        return true;
    }
}

