/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetCardInLibrary;

class BountyOfSkemfarEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("an Elf card");

    BountyOfSkemfarEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal the top six cards of your library. You may put up to one land card from among them onto the battlefield tapped and up to one Elf card from among them into your hand. Put the rest on the bottom of your library in a random order";
    }

    private BountyOfSkemfarEffect(BountyOfSkemfarEffect effect) {
        super((OneShotEffect)effect);
    }

    public BountyOfSkemfarEffect copy() {
        return new BountyOfSkemfarEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl(player.getLibrary().getTopCards(game, 6));
        player.revealCards(source, (Cards)cards, game);
        TargetCardInLibrary target = new TargetCardInLibrary(0, 1, (FilterCard)StaticFilters.FILTER_CARD_LAND);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        Card land = cards.get(target.getFirstTarget(), game);
        if (land != null) {
            player.moveCards(land, Zone.BATTLEFIELD, source, game, true, false, false, null);
        }
        cards.removeIf(uuid -> game.getState().getZone(uuid) != Zone.LIBRARY);
        target = new TargetCardInLibrary(0, 1, filter);
        player.choose(this.outcome, (Cards)cards, (TargetCard)target, source, game);
        Card elf = cards.get(target.getFirstTarget(), game);
        if (elf != null) {
            player.moveCardToHandWithInfo(elf, source, game, true);
        }
        cards.removeIf(uuid -> game.getState().getZone(uuid) != Zone.LIBRARY);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }

    static {
        filter.add((Predicate)SubType.ELF.getPredicate());
    }
}

