/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.Mana;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BountyOfTheLuxaEffect
extends OneShotEffect {
    BountyOfTheLuxaEffect() {
        super(Outcome.Benefit);
        this.staticText = "remove all flood counters from {this}. If no counters were removed this way, put a flood counter on {this} and draw a card. Otherwise, add {C}{G}{U}";
    }

    private BountyOfTheLuxaEffect(BountyOfTheLuxaEffect effect) {
        super((OneShotEffect)effect);
    }

    public BountyOfTheLuxaEffect copy() {
        return new BountyOfTheLuxaEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent bountyOfLuxa = source.getSourcePermanentIfItStillExists(game);
        if (bountyOfLuxa == null) {
            controller.drawCards(1, source, game);
            return true;
        }
        int amountRemoved = bountyOfLuxa.removeAllCounters(CounterType.FLOOD.getName(), source, game);
        if (amountRemoved == 0) {
            new AddCountersSourceEffect(CounterType.FLOOD.createInstance()).apply(game, source);
            controller.drawCards(1, source, game);
        } else {
            Mana manaToAdd = new Mana();
            manaToAdd.increaseColorless();
            manaToAdd.increaseGreen();
            manaToAdd.increaseBlue();
            controller.getManaPool().addMana(manaToAdd, game, source);
        }
        return true;
    }
}

