/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.filter.common.FilterInstantOrSorceryCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.util.CardUtil;

class BrainInAJarCastEffect
extends OneShotEffect {
    BrainInAJarCastEffect() {
        super(Outcome.PlayForFree);
        this.staticText = ", then you may cast an instant or sorcery spell with mana value equal to the number of charge counters on {this} from your hand without paying its mana cost";
    }

    private BrainInAJarCastEffect(BrainInAJarCastEffect effect) {
        super((OneShotEffect)effect);
    }

    public BrainInAJarCastEffect copy() {
        return new BrainInAJarCastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        Permanent sourceObject = source.getSourcePermanentOrLKI(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        int counters = sourceObject.getCounters(game).getCount(CounterType.CHARGE);
        FilterInstantOrSorceryCard filter = new FilterInstantOrSorceryCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.EQUAL_TO, counters));
        return CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Cards)controller.getHand(), (FilterCard)filter);
    }
}

