/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class BrainPryEffect
extends OneShotEffect {
    BrainPryEffect() {
        super(Outcome.Discard);
        this.staticText = "Target player reveals their hand. That player discards a card with that name. If they can't, you draw a card";
    }

    private BrainPryEffect(BrainPryEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player targetPlayer = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        String cardName = (String)game.getState().getValue(source.getSourceId().toString() + "NAMED_CARD");
        if (targetPlayer != null && controller != null && sourceObject != null && cardName != null) {
            boolean hasDiscarded = false;
            for (Card card : targetPlayer.getHand().getCards(game)) {
                if (!CardUtil.haveSameNames((MageObject)card, (String)cardName, (Game)game)) continue;
                targetPlayer.discard(card, false, source, game);
                hasDiscarded = true;
                break;
            }
            if (!hasDiscarded) {
                controller.drawCards(1, source, game);
            }
            controller.lookAtCards(sourceObject.getName() + " Hand", targetPlayer.getHand(), game);
        }
        return true;
    }

    public BrainPryEffect copy() {
        return new BrainPryEffect(this);
    }
}

