/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Objects;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class BrainstealerDragonExileEffect
extends OneShotEffect {
    BrainstealerDragonExileEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of each opponent's library. You may play those cards for as long as they remain exiled. If you cast a spell this way, you may spend mana as though it were mana of any color to cast it";
    }

    private BrainstealerDragonExileEffect(BrainstealerDragonExileEffect effect) {
        super((OneShotEffect)effect);
    }

    public BrainstealerDragonExileEffect copy() {
        return new BrainstealerDragonExileEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        game.getOpponents(source.getControllerId(), true).stream().map(arg_0 -> ((Game)game).getPlayer(arg_0)).filter(Objects::nonNull).map(Player::getLibrary).map(library -> library.getFromTop(game)).forEach(arg_0 -> ((Cards)cards).add(arg_0));
        player.moveCards((Cards)cards, Zone.EXILED, source, game);
        for (Card card : cards.getCards(game)) {
            CardUtil.makeCardPlayable((Game)game, (Ability)source, (Card)card, (boolean)false, (Duration)Duration.Custom, (boolean)true, (UUID)source.getControllerId(), null);
        }
        return true;
    }
}

