/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;

class BreakingWaveEffect
extends OneShotEffect {
    BreakingWaveEffect() {
        super(Outcome.Neutral);
        this.staticText = "Simultaneously untap all tapped creatures and tap all untapped creatures.";
    }

    private BreakingWaveEffect(BreakingWaveEffect copy) {
        super((OneShotEffect)copy);
    }

    public BreakingWaveEffect copy() {
        return new BreakingWaveEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        List creatures = game.getBattlefield().getActivePermanents((FilterPermanent)StaticFilters.FILTER_PERMANENT_CREATURE, source.getControllerId(), source, game);
        for (Permanent creature : creatures) {
            if (creature.isTapped()) {
                creature.untap(game);
                continue;
            }
            creature.tap(source, game);
        }
        return true;
    }
}

