/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.constants.Outcome;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInHand;
import mage.util.CardUtil;

class BreakthroughEffect
extends OneShotEffect {
    BreakthroughEffect() {
        super(Outcome.Discard);
        this.staticText = ", then choose X cards in your hand and discard the rest.";
    }

    private BreakthroughEffect(BreakthroughEffect effect) {
        super((OneShotEffect)effect);
    }

    public BreakthroughEffect copy() {
        return new BreakthroughEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        int amountToKeep = (Integer)CardUtil.getSourceCostsTag((Game)game, (Ability)source, (String)"X", (Object)0);
        if (amountToKeep == 0) {
            player.discard(player.getHand(), false, source, game);
        } else if (amountToKeep < player.getHand().size()) {
            TargetCardInHand target = new TargetCardInHand(amountToKeep, StaticFilters.FILTER_CARD).withChooseHint("to keep");
            target.choose(Outcome.Benefit, player.getId(), source.getSourceId(), source, game);
            Cards cards = player.getHand().copy();
            cards.removeIf(target.getTargets()::contains);
            player.discard(cards, false, source, game);
        }
        return true;
    }
}

