/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BreatheYourLastEffect
extends OneShotEffect {
    BreatheYourLastEffect() {
        super(Outcome.DestroyPermanent);
        this.staticText = "You gain 1 life for each of its colors.";
    }

    private BreatheYourLastEffect(BreatheYourLastEffect effect) {
        super((OneShotEffect)effect);
    }

    public BreatheYourLastEffect copy() {
        return new BreatheYourLastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = this.getTargetPointer().getFirstTargetPermanentOrLKI(game, source);
        Player controller = game.getPlayer(source.getControllerId());
        if (permanent == null || controller == null) {
            return false;
        }
        int colors = permanent.getColor(game).getColorCount();
        return controller.gainLife(colors, game, source) > 0;
    }
}

