/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Optional;
import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CopyStackObjectEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.stack.Spell;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class BreechesTheBlastmakerEffect
extends OneShotEffect {
    BreechesTheBlastmakerEffect() {
        super(Outcome.Benefit);
        this.staticText = "flip a coin. When you win the flip, copy that spell. You may choose new targets for the copy. When you lose the flip, {this} deals damage equal to that spell's mana value to any target";
    }

    private BreechesTheBlastmakerEffect(BreechesTheBlastmakerEffect effect) {
        super((OneShotEffect)effect);
    }

    public BreechesTheBlastmakerEffect copy() {
        return new BreechesTheBlastmakerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        ReflexiveTriggeredAbility ability;
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Spell spell = (Spell)this.getValue("spellCast");
        if (player.flipCoin(source, game, true)) {
            CopyStackObjectEffect effect = new CopyStackObjectEffect();
            effect.setText("copy that spell. You may choose new targets for the copy");
            effect.setTargetPointer((TargetPointer)new FixedTarget(spell.getId(), game));
            ability = new ReflexiveTriggeredAbility((Effect)effect, false);
        } else {
            int mv = Optional.ofNullable(spell).map(Spell::getManaValue).orElse(0);
            ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(mv), false);
            ability.addTarget((Target)new TargetAnyTarget());
        }
        game.fireReflexiveTriggeredAbility(ability, source);
        return true;
    }
}

