/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.UUID;
import mage.ApprovingObject;
import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;
import mage.target.common.TargetOpponent;

class BrilliantUltimatumEffect
extends OneShotEffect {
    BrilliantUltimatumEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "Exile the top five cards of your library. An opponent separates those cards into two piles. You may play lands and cast spells from one of those piles. If you cast a spell this way, you cast it without paying its mana cost";
    }

    private BrilliantUltimatumEffect(BrilliantUltimatumEffect effect) {
        super((OneShotEffect)effect);
    }

    public BrilliantUltimatumEffect copy() {
        return new BrilliantUltimatumEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = game.getObject(source);
        if (controller == null || sourceObject == null) {
            return false;
        }
        CardsImpl pile2 = new CardsImpl();
        pile2.addAllCards((Collection)controller.getLibrary().getTopCards(game, 5));
        controller.moveCardsToExile(pile2.getCards(game), source, game, true, source.getSourceId(), sourceObject.getIdName());
        TargetOpponent targetOpponent = new TargetOpponent(true);
        targetOpponent.choose(this.outcome, source.getControllerId(), source.getSourceId(), source, game);
        Player opponent = game.getPlayer(targetOpponent.getFirstTarget());
        if (opponent != null) {
            CardsImpl selectedPile;
            ArrayList selectedPileCards;
            String selectedPileName;
            TargetCard target = new TargetCard(0, pile2.size(), Zone.EXILED, new FilterCard("cards to put in the first pile"));
            CardsImpl pile1 = new CardsImpl();
            ArrayList pileOne = new ArrayList();
            ArrayList pileTwo = new ArrayList();
            if (opponent.choose(Outcome.Neutral, (Cards)pile2, target, source, game)) {
                List targets = target.getTargets();
                for (UUID targetId : targets) {
                    Card card = pile2.get(targetId, game);
                    if (card == null) continue;
                    pile1.add(card);
                    pile2.remove(card);
                }
            }
            pileOne.addAll(pile1.getCards(game));
            pileTwo.addAll(pile2.getCards(game));
            controller.revealCards("Pile 1 - " + sourceObject.getIdName(), (Cards)pile1, game);
            controller.revealCards("Pile 2 - " + sourceObject.getIdName(), (Cards)pile2, game);
            boolean choice = controller.choosePile(Outcome.PlayForFree, "Which pile (play for free)?", pileOne, pileTwo, game);
            if (choice) {
                selectedPileName = "pile 1";
                selectedPileCards = pileOne;
                selectedPile = pile1;
            } else {
                selectedPileName = "pile 2";
                selectedPileCards = pileTwo;
                selectedPile = pile2;
            }
            game.informPlayers(controller.getLogName() + " chose " + selectedPileName + '.');
            while (!selectedPileCards.isEmpty() && controller.chooseUse(Outcome.PlayForFree, "Play a card for free from " + selectedPileName + '?', source, game)) {
                Card card;
                TargetCard targetExiledCard = new TargetCard(Zone.EXILED, new FilterCard());
                if (!controller.chooseTarget(Outcome.PlayForFree, (Cards)selectedPile, targetExiledCard, source, game) || !controller.playCard(card = selectedPile.get(targetExiledCard.getFirstTarget(), game), game, true, new ApprovingObject(source, game))) continue;
                selectedPileCards.remove(card);
                selectedPile.remove(card);
            }
            return true;
        }
        return false;
    }
}

