/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.HashSet;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.SetBasePowerToughnessAllEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BrineHagEffect
extends OneShotEffect {
    BrineHagEffect() {
        super(Outcome.Detriment);
        this.staticText = "change the base power and toughness of all creatures that dealt damage to it this turn to 0/2";
    }

    private BrineHagEffect(BrineHagEffect effect) {
        super((OneShotEffect)effect);
    }

    public BrineHagEffect copy() {
        return new BrineHagEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        Permanent sourcePermanent = game.getPermanentOrLKIBattlefield(source.getSourceId());
        if (sourcePermanent == null) {
            return false;
        }
        HashSet set = new HashSet(sourcePermanent.getDealtDamageByThisTurn());
        if (!set.isEmpty()) {
            FilterCreaturePermanent filter = new FilterCreaturePermanent();
            filter.add((Predicate)new PermanentReferenceInCollectionPredicate(set));
            game.addEffect((ContinuousEffect)new SetBasePowerToughnessAllEffect(0, 2, Duration.Custom, (FilterPermanent)filter), source);
        }
        return true;
    }
}

