/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.ObjectColor;
import mage.abilities.Ability;
import mage.abilities.costs.Cost;
import mage.abilities.costs.common.RevealTargetFromHandCost;
import mage.abilities.costs.mana.GenericManaCost;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CounterUnlessPaysEffect;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ColorPredicate;
import mage.game.Game;
import mage.target.common.TargetCardInHand;

class BrineSeerEffect
extends OneShotEffect {
    private static final FilterCard filter = new FilterCard("any number of blue cards in your hand");

    public BrineSeerEffect() {
        super(Outcome.Detriment);
        this.staticText = "reveal any number of blue cards in your hand. Counter target spell unless its controller pays {1} for each card revealed this way";
    }

    private BrineSeerEffect(BrineSeerEffect effect) {
        super((OneShotEffect)effect);
    }

    public BrineSeerEffect copy() {
        return new BrineSeerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        RevealTargetFromHandCost cost = new RevealTargetFromHandCost(new TargetCardInHand(0, Integer.MAX_VALUE, filter));
        if (!cost.pay(source, game, source, source.getControllerId(), true)) {
            return false;
        }
        int xValue = cost.getNumberRevealedCards();
        return new CounterUnlessPaysEffect((Cost)new GenericManaCost(xValue)).apply(game, source);
    }

    static {
        filter.add((Predicate)new ColorPredicate(ObjectColor.BLUE));
    }
}

