/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.dynamicvalue.common.ColorsOfManaSpentToCastCount;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.constants.CardType;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.target.common.TargetCardInLibrary;
import mage.util.CardUtil;

class BringToLightEffect
extends OneShotEffect {
    BringToLightEffect() {
        super(Outcome.PlayForFree);
        this.staticText = "search your library for a creature, instant, or sorcery card with mana value less than or equal to the number of colors of mana spent to cast this spell, exile that card, then shuffle. You may cast that card without paying its mana cost";
    }

    private BringToLightEffect(BringToLightEffect effect) {
        super((OneShotEffect)effect);
    }

    public BringToLightEffect copy() {
        return new BringToLightEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        int numberColors = ColorsOfManaSpentToCastCount.getInstance().calculate(game, source, (Effect)this);
        FilterCard filter = new FilterCard("a creature, instant, or sorcery card with mana value less than or equal to " + numberColors);
        filter.add(Predicates.or((Predicate[])new Predicate[]{CardType.CREATURE.getPredicate(), CardType.INSTANT.getPredicate(), CardType.SORCERY.getPredicate()}));
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, numberColors + 1));
        TargetCardInLibrary target = new TargetCardInLibrary(filter);
        controller.searchLibrary(target, source, game);
        Card card = controller.getLibrary().getCard(target.getFirstTarget(), game);
        if (card != null) {
            controller.moveCards(card, Zone.EXILED, source, game);
        }
        controller.shuffleLibrary(source, game);
        CardUtil.castSpellWithAttributesForFree((Player)controller, (Ability)source, (Game)game, (Card)card);
        return true;
    }
}

