/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class BriselaVoiceOfNightmaresCantCastEffect
extends ContinuousRuleModifyingEffectImpl {
    BriselaVoiceOfNightmaresCantCastEffect() {
        super(Duration.WhileOnBattlefield, Outcome.Benefit);
        this.staticText = "Your opponents can't cast spells with mana value 3 or less";
    }

    private BriselaVoiceOfNightmaresCantCastEffect(BriselaVoiceOfNightmaresCantCastEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public BriselaVoiceOfNightmaresCantCastEffect copy() {
        return new BriselaVoiceOfNightmaresCantCastEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject mageObject = game.getObject(source);
        if (mageObject != null) {
            return "You can't cast spells with mana value 3 or less (" + mageObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.CAST_SPELL_LATE;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Spell spell;
        if (game.getOpponents(source.getControllerId()).contains(event.getPlayerId()) && (spell = game.getStack().getSpell(event.getTargetId())) != null) {
            return spell.getManaValue() < 4;
        }
        return false;
    }
}

