/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.constants.SubType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.game.Game;
import mage.game.permanent.token.EldraziSpawnToken;

class BroodBirthingEffect
extends OneShotEffect {
    BroodBirthingEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "If you control an Eldrazi Spawn, create three 0/1 colorless Eldrazi Spawn creature tokens. They have \"Sacrifice this creature: Add {C}.\" Otherwise, create one of those tokens";
    }

    private BroodBirthingEffect(BroodBirthingEffect effect) {
        super((OneShotEffect)effect);
    }

    public BroodBirthingEffect copy() {
        return new BroodBirthingEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        FilterControlledCreaturePermanent filter = new FilterControlledCreaturePermanent("Eldrazi Spawn");
        filter.add((Predicate)SubType.ELDRAZI.getPredicate());
        filter.add((Predicate)SubType.SPAWN.getPredicate());
        EldraziSpawnToken token = new EldraziSpawnToken();
        int count = game.getBattlefield().countAll((FilterPermanent)filter, source.getControllerId(), game) > 0 ? 3 : 1;
        token.putOntoBattlefield(count, game, source, source.getControllerId());
        return true;
    }
}

