/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenEffect;
import mage.abilities.effects.common.asthought.PlayFromNotOwnHandZoneTargetEffect;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.TargetController;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.permanent.token.Ox22Token;
import mage.game.permanent.token.Token;
import mage.players.Library;
import mage.players.Player;

class BruseTarlRovingRancherEffect
extends OneShotEffect {
    BruseTarlRovingRancherEffect() {
        super(Outcome.Benefit);
        this.staticText = "exile the top card of your library. If it's a land card, create a 2/2 white Ox creature token. Otherwise, you may cast it until the end of your next turn.";
    }

    private BruseTarlRovingRancherEffect(BruseTarlRovingRancherEffect effect) {
        super((OneShotEffect)effect);
    }

    public BruseTarlRovingRancherEffect copy() {
        return new BruseTarlRovingRancherEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        Library library = player.getLibrary();
        if (library == null || !library.hasCards()) {
            return false;
        }
        Card card = library.getFromTop(game);
        if (card == null) {
            return false;
        }
        if (card.isLand(game)) {
            player.moveCards(card, Zone.EXILED, source, game);
            new CreateTokenEffect((Token)new Ox22Token()).apply(game, source);
        } else {
            PlayFromNotOwnHandZoneTargetEffect.exileAndPlayFromExile((Game)game, (Ability)source, (Card)card, (TargetController)TargetController.YOU, (Duration)Duration.UntilEndOfYourNextTurn, (boolean)false, (boolean)false, (boolean)true);
        }
        return true;
    }
}

