/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.FlipSourceEffect;
import mage.cards.b.DokaiWeaverofLife;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterControlledLandPermanent;
import mage.filter.common.FilterControlledPermanent;
import mage.game.Game;
import mage.game.permanent.token.Token;
import mage.players.Player;

class BudokaGardenerEffect
extends OneShotEffect {
    static final FilterControlledPermanent filterLands = new FilterControlledLandPermanent("lands you control");

    BudokaGardenerEffect() {
        super(Outcome.PutLandInPlay);
        this.staticText = "If you control ten or more lands, flip {this}";
    }

    private BudokaGardenerEffect(BudokaGardenerEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        if (game.getBattlefield().count((FilterPermanent)filterLands, source.getControllerId(), source, game) < 10) {
            return false;
        }
        return new FlipSourceEffect((Token)new DokaiWeaverofLife()).apply(game, source);
    }

    public BudokaGardenerEffect copy() {
        return new BudokaGardenerEffect(this);
    }
}

