/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;

class BurnTheAccursedEffect
extends OneShotEffect {
    BurnTheAccursedEffect() {
        super(Outcome.Benefit);
        this.staticText = "{this} deals 5 damage to target creature and 2 damage to that creature's controller.";
    }

    private BurnTheAccursedEffect(BurnTheAccursedEffect effect) {
        super((OneShotEffect)effect);
    }

    public BurnTheAccursedEffect copy() {
        return new BurnTheAccursedEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = game.getPermanent(source.getFirstTarget());
        if (permanent == null) {
            return false;
        }
        permanent.damage(5, source.getSourceId(), source, game);
        Player player = game.getPlayer(permanent.getControllerId());
        if (player != null) {
            player.damage(2, source.getSourceId(), source, game);
        }
        return true;
    }
}

