/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.ComparisonType;
import mage.constants.Outcome;
import mage.filter.FilterCard;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.mageobject.ManaValuePredicate;
import mage.game.Game;
import mage.players.Player;
import mage.util.CardUtil;

class BusterSwordEffect
extends OneShotEffect {
    BusterSwordEffect() {
        super(Outcome.Benefit);
        this.staticText = ", then you may cast a spell from your hand with mana value less than or equal to that damage without paying its mana cost";
    }

    private BusterSwordEffect(BusterSwordEffect effect) {
        super((OneShotEffect)effect);
    }

    public BusterSwordEffect copy() {
        return new BusterSwordEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || player.getHand().isEmpty()) {
            return false;
        }
        int damage = (Integer)this.getValue("damage");
        FilterCard filter = new FilterCard();
        filter.add((Predicate)new ManaValuePredicate(ComparisonType.FEWER_THAN, damage + 1));
        return CardUtil.castSpellWithAttributesForFree((Player)player, (Ability)source, (Game)game, (Cards)new CardsImpl((Collection)player.getHand()), (FilterCard)filter);
    }
}

