/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import java.util.Set;
import java.util.UUID;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetOpponent;

class BuzzingWhackADoodleEffect
extends OneShotEffect {
    BuzzingWhackADoodleEffect() {
        super(Outcome.Benefit);
        this.staticText = "You and an opponent each secretly choose Whack or Doodle. Then those choices are revealed. If the choices match, {this} has that ability. Otherwise it has Buzz";
    }

    private BuzzingWhackADoodleEffect(BuzzingWhackADoodleEffect effect) {
        super((OneShotEffect)effect);
    }

    public BuzzingWhackADoodleEffect copy() {
        return new BuzzingWhackADoodleEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player controller = game.getPlayer(source.getControllerId());
        if (controller != null) {
            int whackCount = 0;
            int doodleCount = 0;
            if (controller.chooseUse(Outcome.Benefit, "Choose Whack (yes) or Doodle (no)?", source, game)) {
                ++whackCount;
            } else {
                ++doodleCount;
            }
            Set opponents = game.getOpponents(source.getControllerId());
            if (!opponents.isEmpty()) {
                TargetOpponent targetOpponent;
                Player opponent = game.getPlayer((UUID)opponents.iterator().next());
                if (opponents.size() > 1 && controller.chooseTarget(Outcome.Neutral, (Target)(targetOpponent = new TargetOpponent(true)), source, game)) {
                    opponent = game.getPlayer(targetOpponent.getFirstTarget());
                    game.informPlayers(controller.getLogName() + " chose " + opponent.getLogName() + " to choose Whack or Doodle");
                }
                if (opponent != null) {
                    if (opponent.chooseUse(Outcome.Benefit, "Choose Whack (yes) or Doodle (no)?", source, game)) {
                        ++whackCount;
                    } else {
                        ++doodleCount;
                    }
                }
            }
            if (whackCount == 2) {
                game.informPlayers("Whack was chosen");
                game.getState().setValue("whack" + source.getSourceId(), (Object)Boolean.TRUE);
            } else if (doodleCount == 2) {
                game.informPlayers("Doodle was chosen");
                game.getState().setValue("doodle" + source.getSourceId(), (Object)Boolean.TRUE);
            } else {
                game.informPlayers("Buzz was chosen");
                game.getState().setValue("buzz" + source.getSourceId(), (Object)Boolean.TRUE);
            }
            return true;
        }
        return false;
    }
}

