/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousRuleModifyingEffectImpl;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.stack.Spell;

class DeterminedEffect
extends ContinuousRuleModifyingEffectImpl {
    DeterminedEffect() {
        super(Duration.EndOfTurn, Outcome.Benefit);
        this.staticText = "Other spells you control can't be countered this turn";
    }

    private DeterminedEffect(DeterminedEffect effect) {
        super((ContinuousRuleModifyingEffectImpl)effect);
    }

    public DeterminedEffect copy() {
        return new DeterminedEffect(this);
    }

    public String getInfoMessage(Ability source, GameEvent event, Game game) {
        MageObject sourceObject = game.getObject(source);
        if (sourceObject != null) {
            return "This spell can't be countered (" + sourceObject.getIdName() + ").";
        }
        return null;
    }

    public boolean checksEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.COUNTER;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        Spell spell = game.getStack().getSpell(event.getTargetId());
        return spell != null && !spell.getSourceId().equals(source.getSourceId()) && spell.isControlledBy(source.getControllerId());
    }
}

