/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.b;

import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.Card;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.filter.FilterCard;
import mage.filter.StaticFilters;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetCard;
import mage.target.common.TargetCardInGraveyard;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;
import mage.util.CardUtil;

class EnteringReturnFromGraveyardToBattlefieldEffect
extends OneShotEffect {
    EnteringReturnFromGraveyardToBattlefieldEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Put a creature card from a graveyard onto the battlefield under your control. It gains haste until end of turn.";
    }

    private EnteringReturnFromGraveyardToBattlefieldEffect(EnteringReturnFromGraveyardToBattlefieldEffect effect) {
        super((OneShotEffect)effect);
    }

    public EnteringReturnFromGraveyardToBattlefieldEffect copy() {
        return new EnteringReturnFromGraveyardToBattlefieldEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent;
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        if (controller == null) {
            return false;
        }
        TargetCard target = new TargetCardInGraveyard((FilterCard)StaticFilters.FILTER_CARD_CREATURE).withNotTarget(true);
        if (target.canChoose(source.getControllerId(), source, game) && controller.chooseTarget(this.outcome, (Target)target, source, game) && (card = game.getCard(target.getFirstTarget())) != null && controller.moveCards(card, Zone.BATTLEFIELD, source, game) && (permanent = CardUtil.getPermanentFromCardPutToBattlefield((Card)card, (Game)game)) != null) {
            GainAbilityTargetEffect effect = new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent.getId(), game));
            game.addEffect((ContinuousEffect)effect, source);
        }
        return true;
    }
}

