/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.Mana;
import mage.abilities.TriggeredAbilityImpl;
import mage.abilities.effects.common.counter.AddCountersTargetEffect;
import mage.cards.c.CAMPEffect;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.events.TappedForManaEvent;
import mage.game.permanent.Permanent;
import mage.target.Target;
import mage.target.common.TargetControlledCreaturePermanent;

class CAMPTriggeredAbility
extends TriggeredAbilityImpl {
    CAMPTriggeredAbility() {
        super(Zone.BATTLEFIELD, null);
        this.addTarget((Target)new TargetControlledCreaturePermanent());
    }

    private CAMPTriggeredAbility(CAMPTriggeredAbility ability) {
        super((TriggeredAbilityImpl)ability);
    }

    public CAMPTriggeredAbility copy() {
        return new CAMPTriggeredAbility(this);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.TAPPED_FOR_MANA;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent fortification = game.getPermanent(this.getSourceId());
        if (fortification == null || !event.getSourceId().equals(fortification.getAttachedTo())) {
            return false;
        }
        TappedForManaEvent mEvent = (TappedForManaEvent)event;
        Mana mana = mEvent.getMana();
        this.getEffects().clear();
        this.getEffects().add((Object)new AddCountersTargetEffect(CounterType.P1P1.createInstance()));
        this.getEffects().add((Object)new CAMPEffect(mana));
        return true;
    }

    public String getRule() {
        return "Whenever fortified land is tapped for mana, put a +1/+1 counter on target creature you control. If that creature shares a color with the mana that land produced, create a Junk token.";
    }
}

