/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.abilities.effects.common.continuous.GainAbilityTargetEffect;
import mage.abilities.keyword.HasteAbility;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.target.targetpointer.FixedTargets;
import mage.target.targetpointer.TargetPointer;

class CadricSoulKindlerTokenEffect
extends OneShotEffect {
    CadricSoulKindlerTokenEffect() {
        super(Outcome.Benefit);
        this.staticText = "create a token that's a copy of it. That token gains haste. Sacrifice it at the beginning of the next end step";
    }

    private CadricSoulKindlerTokenEffect(CadricSoulKindlerTokenEffect effect) {
        super((OneShotEffect)effect);
    }

    public CadricSoulKindlerTokenEffect copy() {
        return new CadricSoulKindlerTokenEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Permanent permanent = (Permanent)this.getValue("permanentEnteringBattlefield");
        if (permanent == null) {
            return false;
        }
        CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect();
        effect.setSavedPermanent(permanent);
        effect.apply(game, source);
        game.addEffect(new GainAbilityTargetEffect((Ability)HasteAbility.getInstance(), Duration.Custom).setTargetPointer((TargetPointer)new FixedTargets((Collection)effect.getAddedPermanents(), game)), source);
        effect.sacrificeTokensCreatedAtNextEndStep(game, source);
        return true;
    }
}

