/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.ObjectColor;
import mage.abilities.effects.mana.ManaEffect;
import mage.abilities.mana.TriggeredManaAbility;
import mage.cards.c.CagedSunEffect;
import mage.constants.Zone;
import mage.game.Game;
import mage.game.events.GameEvent;
import mage.game.permanent.Permanent;

class CagedSunTriggeredAbility
extends TriggeredManaAbility {
    private static final String staticText = "Whenever a land's ability causes you to add one or more mana of the chosen color, add one additional mana of that color.";

    public CagedSunTriggeredAbility() {
        super(Zone.BATTLEFIELD, (ManaEffect)new CagedSunEffect());
    }

    private CagedSunTriggeredAbility(CagedSunTriggeredAbility ability) {
        super((TriggeredManaAbility)ability);
    }

    public boolean checkEventType(GameEvent event, Game game) {
        return event.getType() == GameEvent.EventType.MANA_ADDED;
    }

    public boolean checkTrigger(GameEvent event, Game game) {
        Permanent permanent;
        if (event.getPlayerId().equals(this.controllerId) && (permanent = game.getPermanentOrLKIBattlefield(event.getSourceId())) != null && permanent.isLand(game)) {
            ObjectColor color = (ObjectColor)game.getState().getValue(this.sourceId + "_color");
            return color != null && event.getData().contains(color.toString());
        }
        return false;
    }

    public CagedSunTriggeredAbility copy() {
        return new CagedSunTriggeredAbility(this);
    }

    public String getRule() {
        return staticText;
    }
}

