/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.counter.AddCountersSourceEffect;
import mage.cards.Card;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.counters.CounterType;
import mage.filter.FilterCard;
import mage.game.Game;
import mage.players.Player;
import mage.target.TargetCard;

class CaitCageBrawlerEffect
extends OneShotEffect {
    CaitCageBrawlerEffect() {
        super(Outcome.Benefit);
        this.staticText = "you and defending player each draw a card, then discard a card. Put two +1/+1 counters on {this} if you discarded the card with the greatest mana value among those cards or tied for greatest";
    }

    protected CaitCageBrawlerEffect(CaitCageBrawlerEffect effect) {
        super((OneShotEffect)effect);
    }

    public CaitCageBrawlerEffect copy() {
        return new CaitCageBrawlerEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Card card2;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        controller.drawCards(1, source, game);
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent != null) {
            opponent.drawCards(1, source, game);
        }
        int mvController = Integer.MIN_VALUE;
        Card cardController = null;
        int mvOpponent = Integer.MIN_VALUE;
        Card cardOpponent = null;
        TargetCard controllerTarget = new TargetCard(Zone.HAND, new FilterCard());
        if (controller.choose(Outcome.Discard, controller.getHand(), controllerTarget, source, game) && (card2 = controller.getHand().get(controllerTarget.getFirstTarget(), game)) != null) {
            cardController = card2;
            mvController = card2.getManaValue();
        }
        TargetCard opponentTarget = new TargetCard(Zone.HAND, new FilterCard());
        if (opponent != null && opponent.choose(Outcome.Discard, opponent.getHand(), opponentTarget, source, game) && (card = opponent.getHand().get(opponentTarget.getFirstTarget(), game)) != null) {
            cardOpponent = card;
            mvOpponent = card.getManaValue();
        }
        if (cardOpponent != null) {
            opponent.discard(cardOpponent, false, source, game);
        }
        if (cardController != null) {
            controller.discard(cardController, false, source, game);
            if (mvController > mvOpponent) {
                new AddCountersSourceEffect(CounterType.P1P1.createInstance(2)).apply(game, source);
            }
        }
        return true;
    }
}

