/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.CreateTokenCopyTargetEffect;
import mage.constants.Outcome;
import mage.constants.SuperType;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.ObjectSourcePlayerPredicate;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.Predicates;
import mage.filter.predicate.permanent.SaddledSourceThisTurnPredicate;
import mage.game.Game;
import mage.game.permanent.Permanent;
import mage.players.Player;
import mage.target.Target;
import mage.target.TargetPermanent;
import mage.target.targetpointer.FixedTarget;
import mage.target.targetpointer.TargetPointer;

class CalamityGallopingInfernoEffect
extends OneShotEffect {
    private static final FilterPermanent filter = new FilterCreaturePermanent("nonlegendary creature that saddled it this turn");

    CalamityGallopingInfernoEffect() {
        super(Outcome.Benefit);
        this.staticText = "choose a nonlegendary creature that saddled it this turn and create a tapped and attacking token that's a copy of it. Sacrifice that token at the beginning of the next end step. Repeat this process once";
    }

    private CalamityGallopingInfernoEffect(CalamityGallopingInfernoEffect effect) {
        super((OneShotEffect)effect);
    }

    public CalamityGallopingInfernoEffect copy() {
        return new CalamityGallopingInfernoEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null || !game.getBattlefield().contains(filter, source, game, 1)) {
            return false;
        }
        for (int i = 0; i < 2; ++i) {
            TargetPermanent target = new TargetPermanent(filter);
            target.withNotTarget(true);
            player.choose(this.outcome, (Target)target, source, game);
            Permanent permanent = game.getPermanent(target.getFirstTarget());
            if (permanent == null) continue;
            CreateTokenCopyTargetEffect effect = new CreateTokenCopyTargetEffect(null, null, false, 1, true, true);
            effect.setTargetPointer((TargetPointer)new FixedTarget(permanent, game));
            effect.apply(game, source);
            effect.sacrificeTokensCreatedAtNextEndStep(game, source);
        }
        return true;
    }

    static {
        filter.add(Predicates.not((Predicate)SuperType.LEGENDARY.getPredicate()));
        filter.add((ObjectSourcePlayerPredicate)SaddledSourceThisTurnPredicate.instance);
    }
}

