/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.common.delayed.ReflexiveTriggeredAbility;
import mage.abilities.effects.Effect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.DamageTargetEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.game.Game;
import mage.players.Player;
import mage.target.Target;
import mage.target.common.TargetAnyTarget;

class CalibratedBlastEffect
extends OneShotEffect {
    CalibratedBlastEffect() {
        super(Outcome.Benefit);
        this.staticText = "reveal cards from the top of your library until you reveal a nonland card. Put the revealed cards on the bottom of your library in a random order. When you reveal a nonland card this way, {this} deals damage equal to that card's mana value to any target";
    }

    private CalibratedBlastEffect(CalibratedBlastEffect effect) {
        super((OneShotEffect)effect);
    }

    public CalibratedBlastEffect copy() {
        return new CalibratedBlastEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Player player = game.getPlayer(source.getControllerId());
        if (player == null) {
            return false;
        }
        CardsImpl cards = new CardsImpl();
        for (Card card : player.getLibrary().getCards(game)) {
            cards.add(card);
            if (card.isLand(game)) continue;
            ReflexiveTriggeredAbility ability = new ReflexiveTriggeredAbility((Effect)new DamageTargetEffect(card.getManaValue()), false, "When you reveal a nonland card this way, {this} deals damage equal to that card's mana value to any target");
            ability.addTarget((Target)new TargetAnyTarget());
            game.fireReflexiveTriggeredAbility(ability, source);
            break;
        }
        player.revealCards(source, (Cards)cards, game);
        player.putCardsOnBottomOfLibrary((Cards)cards, game, source, false);
        return true;
    }
}

