/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import java.util.Collection;
import java.util.List;
import mage.abilities.Ability;
import mage.abilities.effects.ContinuousEffect;
import mage.abilities.effects.OneShotEffect;
import mage.abilities.effects.common.UntapAllEffect;
import mage.abilities.effects.common.continuous.GainAbilityAllEffect;
import mage.abilities.effects.common.continuous.GainControlAllEffect;
import mage.abilities.keyword.HasteAbility;
import mage.cards.c.CallForAidCantAttackThatPlayerEffect;
import mage.cards.c.CallForAidYouCantSacrificeEffect;
import mage.constants.Duration;
import mage.constants.Outcome;
import mage.filter.FilterPermanent;
import mage.filter.common.FilterCreaturePermanent;
import mage.filter.predicate.Predicate;
import mage.filter.predicate.permanent.ControllerIdPredicate;
import mage.filter.predicate.permanent.PermanentReferenceInCollectionPredicate;
import mage.game.Game;
import mage.players.Player;

class CallForAidEffect
extends OneShotEffect {
    CallForAidEffect() {
        super(Outcome.Benefit);
        this.staticText = "Gain control of all creatures target opponent controls until end of turn. Untap those creatures. They gain haste until end of turn. You can't attack that player this turn. You can't sacrifice those creatures this turn.";
    }

    private CallForAidEffect(CallForAidEffect effect) {
        super((OneShotEffect)effect);
    }

    public boolean apply(Game game, Ability source) {
        Player opponent = game.getPlayer(this.getTargetPointer().getFirst(game, source));
        if (opponent == null) {
            return false;
        }
        FilterCreaturePermanent filter = new FilterCreaturePermanent();
        filter.add((Predicate)new ControllerIdPredicate(opponent.getId()));
        List opponentCreatures = game.getBattlefield().getActivePermanents((FilterPermanent)filter, source.getControllerId(), game);
        filter = new FilterPermanent();
        filter.add((Predicate)new PermanentReferenceInCollectionPredicate((Collection)opponentCreatures, game));
        new GainControlAllEffect(Duration.EndOfTurn, (FilterPermanent)filter).apply(game, source);
        game.processAction();
        new UntapAllEffect((FilterPermanent)filter).apply(game, source);
        game.addEffect((ContinuousEffect)new GainAbilityAllEffect((Ability)HasteAbility.getInstance(), Duration.EndOfTurn, (FilterPermanent)filter), source);
        game.addEffect(new CallForAidCantAttackThatPlayerEffect().setTargetPointer(this.getTargetPointer().copy()), source);
        game.addEffect((ContinuousEffect)new CallForAidYouCantSacrificeEffect(source.getControllerId(), (FilterPermanent)filter), source);
        return true;
    }

    public CallForAidEffect copy() {
        return new CallForAidEffect(this);
    }
}

