/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.MageObject;
import mage.abilities.Ability;
import mage.abilities.effects.OneShotEffect;
import mage.cards.Card;
import mage.cards.Cards;
import mage.cards.CardsImpl;
import mage.constants.Outcome;
import mage.constants.Zone;
import mage.game.Game;
import mage.players.Player;

class CallOfTheWildEffect
extends OneShotEffect {
    CallOfTheWildEffect() {
        super(Outcome.PutCreatureInPlay);
        this.staticText = "Reveal the top card of your library. If it's a creature card, put it onto the battlefield. Otherwise, put it into your graveyard";
    }

    private CallOfTheWildEffect(CallOfTheWildEffect effect) {
        super((OneShotEffect)effect);
    }

    public CallOfTheWildEffect copy() {
        return new CallOfTheWildEffect(this);
    }

    public boolean apply(Game game, Ability source) {
        Card card;
        Player controller = game.getPlayer(source.getControllerId());
        MageObject sourceObject = source.getSourceObject(game);
        if (controller == null || sourceObject == null) {
            return false;
        }
        if (controller.getLibrary().hasCards() && (card = controller.getLibrary().getFromTop(game)) != null) {
            CardsImpl cards = new CardsImpl(card);
            controller.revealCards(sourceObject.getIdName(), (Cards)cards, game);
            if (card.isCreature(game)) {
                controller.moveCards(card, Zone.BATTLEFIELD, source, game);
            } else {
                controller.moveCards(card, Zone.GRAVEYARD, source, game);
            }
        }
        return true;
    }
}

