/*
 * Decompiled with CFR 0.152.
 */
package mage.cards.c;

import mage.abilities.Ability;
import mage.abilities.effects.PreventionEffectImpl;
import mage.constants.Duration;
import mage.game.Game;
import mage.game.events.DamageEvent;
import mage.game.events.GameEvent;
import mage.game.events.PreventDamageEvent;
import mage.game.events.PreventedDamageEvent;
import mage.players.Player;

class CandlesGlowPreventDamageTargetEffect
extends PreventionEffectImpl {
    private int amount = 3;

    public CandlesGlowPreventDamageTargetEffect(Duration duration) {
        super(duration);
        this.staticText = "Prevent the next 3 damage that would be dealt to any target this turn. You gain life equal to the damage prevented this way";
    }

    private CandlesGlowPreventDamageTargetEffect(CandlesGlowPreventDamageTargetEffect effect) {
        super((PreventionEffectImpl)effect);
        this.amount = effect.amount;
    }

    public CandlesGlowPreventDamageTargetEffect copy() {
        return new CandlesGlowPreventDamageTargetEffect(this);
    }

    public boolean replaceEvent(GameEvent event, Ability source, Game game) {
        PreventDamageEvent preventEvent = new PreventDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), event.getAmount(), ((DamageEvent)event).isCombatDamage());
        if (!game.replaceEvent((GameEvent)preventEvent)) {
            Player controller;
            int prevented;
            int damage;
            if (event.getAmount() >= this.amount) {
                damage = this.amount;
                event.setAmount(event.getAmount() - this.amount);
                this.used = true;
                game.fireEvent((GameEvent)new PreventedDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), damage));
                prevented = damage;
            } else {
                damage = event.getAmount();
                event.setAmount(0);
                this.amount -= damage;
                game.fireEvent((GameEvent)new PreventedDamageEvent(event.getTargetId(), source.getSourceId(), source, source.getControllerId(), damage));
                prevented = damage;
            }
            if (prevented > 0 && (controller = game.getPlayer(source.getControllerId())) != null) {
                controller.gainLife(prevented, game, source);
                game.informPlayers("Candles' Glow: Prevented " + prevented + " damage ");
                game.informPlayers("Candles' Glow: " + controller.getLogName() + " gained " + prevented + "life");
            }
        }
        return false;
    }

    public boolean applies(GameEvent event, Ability source, Game game) {
        if (!this.used && super.applies(event, source, game)) {
            return source.getTargets().getFirstTarget().equals(event.getTargetId());
        }
        return false;
    }
}

